//////////////////////////////////////////////
// main.cpp
//
//////////////////////////////////////////////

/// Includes ---------------------------------

// nkLog
#include <NilkinsLog/Loggers/ConsoleLogger.h>

// nkGraphics
#include <NilkinsScripts/Log/LogManager.h>
#include <NilkinsScripts/Environments/Environment.h>
#include <NilkinsScripts/Environments/EnvironmentManager.h>

#include <NilkinsScripts/Interpreters/Interpreter.h>

#include <NilkinsScripts/Scripts/Script.h>
#include <NilkinsScripts/Scripts/ScriptManager.h>

// Standards
#include <memory>

/// Function ---------------------------------

int main ()
{
	// Prepare the logging capabilities
	std::unique_ptr<nkLog::Logger> logger = std::make_unique<nkLog::ConsoleLogger>() ;
	nkScripts::LogManager::getInstance()->setReceiver(logger.get()) ;

	// Create the environment we will work with
	nkScripts::Environment* env = nkScripts::EnvironmentManager::getInstance()->createOrRetrieve("firstEnv") ;
	env->setEnvironmentFor(nkScripts::INTERPRETER::LUA) ;

	// Environments execute scripts, we need to create one, and set its interpreter
	nkScripts::Script* script = nkScripts::ScriptManager::getInstance()->createOrRetrieve("firstScript") ;
	script->setTargetInterpreter(nkScripts::INTERPRETER::LUA) ;

	// Sources depend on the interpreter chosen, here we write lua code
	script->setSources
	(
		R"eos(
			s = 1 ;
			t = s + 5 ;

			print(t) ;
		)eos"
	) ;

	// Triggers compilation of bytecode to use within the environment
	script->load() ;

	// Execution is as simple as asking the environment to execute the script
	env->execute(*script) ;

	// Small pause to be able to witness the console
	system("pause") ;

	return 0 ;
}